/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.debuffs;

import dev.toma.gunsrpg.common.debuffs.IDebuff;
import dev.toma.gunsrpg.common.debuffs.IDebuffBuilder;
import dev.toma.gunsrpg.common.debuffs.IDebuffType;
import java.util.function.BooleanSupplier;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class DebuffType<D extends IDebuff>
extends ForgeRegistryEntry<DebuffType<?>>
implements IDebuffType<D> {
    private final IFactory<D> factory;
    private final BooleanSupplier isBlacklisted;

    public DebuffType(IDebuffBuilder<D> builder) {
        this.factory = builder.getFactory();
        this.isBlacklisted = builder.disabledStatusSupplier();
    }

    @Override
    public D createRaw() {
        return this.factory.createWithType(this);
    }

    @Override
    public boolean isDisabled() {
        return this.isBlacklisted.getAsBoolean();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DebuffType) {
            DebuffType other = (DebuffType)obj;
            return other.getRegistryName().equals((Object)this.getRegistryName());
        }
        return false;
    }

    public int hashCode() {
        return this.getRegistryName().hashCode();
    }

    public static interface IFactory<D extends IDebuff> {
        public D createWithType(IDebuffType<D> var1);
    }
}

